
/' Entity Import '/

Declare Sub Scene_Render ( ByRef Page As Story_Page_Type )

/' Entity About '/

Declare Sub Entity_Parts ( ByVal Subject As String = "", ByRef Classification As String = "", ByRef ID As String = "", ByRef Count As Long = 0 )

Declare Function Entity_Sprite ( ByVal Subject As String ) As FB.Image Ptr

/' Entity Rendering '/

Declare Sub Entity_Scale ( Source As FB.Image Ptr, ByRef Dest As FB.Image Ptr )

Declare Sub Entity_Render ( Entity ( Any ) As String, ByRef Dest As FB.Image Ptr )

Sub Scene_Render ( ByRef Page As Story_Page_Type )

	Dim As FB.Image Ptr Backdrop

	Dim As String Backdrop_Image = ".\" & ProjectSpace & "\Assets\Sprites\interface\" & "background" & ".png"

	If Is_File ( Backdrop_Image ) Then

		Backdrop = LoadRGBAFile ( Backdrop_Image )

	Else

		Backdrop = ImageCreate ( 64, 64, RGBA ( 0, 0, 0, 0 ), 32 )

	End If

	Dim As FB.Image Ptr Source

	Dim As String Source_Image = ".\" & ProjectSpace & "\Assets\Sprites\scene\" & Page.Sprite & ".png"

	If Is_File ( Source_Image ) Then

		Source = LoadRGBAFile ( Source_Image )

	Else

		Source = ImageCreate ( 64, 64, RGBA ( 0, 0, 0, 0 ), 32 )

	End If

	Gfx_Buffer_Repeat ( Backdrop, DispOut ( Page.Index, Pg_Background ) )

	Gfx_Buffer_Stretch_Aspect ( Source, DispOut ( Page.Index, Pg_Illustration ) )

	If Page.Scene <> 0 Then
		ImageDestroy ( Page.Scene )
	End If
	
	Dim As FB.Image Ptr NPC_Sprite, Item_Sprite
	
	Dim As FB.Image Ptr NPC_Sprite_2, Item_Sprite_2
	
	Dim As Long NPC_Index = 0, Item_Index = 0
	
	Dim As Long X = 0, Y = 0
	
	Page.Scene = ImageCreate ( DispOut ( 0, Pg_Illustration ) - > Width * 2, DispOut ( 0, Pg_Illustration ) - > Height * 2, RGBA( 0, 0, 0, 0 ), 32 )
	
	Entity_Render ( Page.Entity ( ), Page.Scene )
	
	Put DispOut( PageLocation, Pg_Scene ), ( ( DispOut( PageLocation, Pg_Scene ) - > Width - Page.Scene - > Width ) \ 2, ( DispOut( PageLocation, Pg_Scene ) - > Height - Page.Scene - > Height ) \ 2 ), Page.Scene, Alpha

	ImageDestroy Backdrop

	ImageDestroy Source

End Sub

Sub Entity_Scale ( Source As FB.Image Ptr, ByRef Dest As FB.Image Ptr )
	
	IF Source = 0 Then
			
		Exit Sub
	
	End If

	IF Dest <> 0 Then
			
		ImageDestroy ( Dest )
	
	End If
	
	Dest = ImageCreate ( 32, 32, RGBA( 0, 0, 0, 0 ), 32 )

	Line ( 0, 0 ) - ( Dest - > Width, Dest - > Height ), RGBA( 255, 255, 0, 196 )

	Line ( Dest - > Width, 0 ) - ( 0, Dest - > Height ), RGBA( 255, 255, 0, 196 )
	
	Gfx_Buffer_Stretch_Aspect( Source, Dest )

End Sub


Sub Entity_Render ( Entity ( Any ) As String, ByRef Dest As FB.Image Ptr )

	Dim As Long Entity_Index = 0, X = 0, Y = 0

	Dim As Double r = 0.0, x0 = 0.0, y0 = 0.0, cX = 0.0, cY = 0.0, x2 = 0.0, y2 = 0.0

	Dim As FB.Image Ptr Entity_Sprite_Source, Entity_Sprite_Scaled
	
	Dim As Long sX = 24, sY = 24
	
	Dim As String Classification = "", ID = ""
	
	Dim As Long	Count = 0
	
	cX = ( Dest - > Width ) \ 2
	cY = ( Dest - > Height ) \ 2

	For Entity_Index = 1 To UBound( Entity, 1 ) Step 1
			
		Entity_Parts ( Entity ( Entity_Index ), Classification, ID, Count )

		r = Entity_Index / UBound( Entity, 1 )
		
		x0 = - cos( 2 * Pi * r )
		y0 = sin( 2 * Pi * r )
		
		Select Case LCase ( Classification )
		
		Case "npc"
		
			r + = 0.27
		
			x0 = x0 * 48.0
			y0 = y0 * 24.0
		
			sX = 24
			sY = 24
		
		Case "item"

			r + = 0.27
			
			x0 = x0 * 120.0
			y0 = y0 * 32.0

			sX = 16
			sY = 16
		
		End Select
						
		Entity_Sprite_Source = Entity_Sprite( ID )
		
		If Entity_Sprite_Source <> 0 Then
		
			Entity_Sprite_Scaled = ImageCreate ( sX, sY, RGBA ( 0, 0, 0, 0 ), 32 )
		
			Entity_Scale ( Entity_Sprite_Source, Entity_Sprite_Scaled )

			If Entity_Sprite_Scaled <> 0 Then
				
				x2 = cX - x0 - Entity_Sprite_Scaled - > Width / 2
				y2 = cY - y0 - Entity_Sprite_Scaled - > Height / 2

				Put Dest, ( x2, y2 ), Entity_Sprite_Scaled, Alpha
			
				ImageDestroy ( Entity_Sprite_Scaled )
			
			End If
			
			ImageDestroy ( Entity_Sprite_Source )
			
		End If
	
	Next Entity_Index

	Exit Sub

End Sub

Sub Entity_Parts ( ByVal Subject As String = "", ByRef Classification As String = "", ByRef ID As String = "", ByRef Count As Long = 0 )

	If StrPos( " = ", Subject ) > 0 Then
		
		Classification = LCase( Prefix( " = ", Subject ) )
		
		Subject = Suffix ( " = ", Subject )
		
	End If

	If StrPos( ":", Subject ) > 0 Then
		
		Count = ValInt ( PreFix ( ":", Subject ) )
		
		Subject = Suffix ( " = ", Subject )
	
	End If
	
	ID = Subject
	
End Sub

Function Entity_Sprite ( ByVal Subject As String ) As FB.Image Ptr
	
	Dim As String Classification = "", ID = ""
	
	Dim As Long	Count = 0
	
	Entity_Parts ( Subject, Classification, ID, Count )
	
	If Is_File ( ".\" & ProjectSpace & "\Assets\Sprites\" & Classification & "\" & ID & ".png" ) Then
		
		Return LoadRGBAFile ( ".\" & ProjectSpace & "\Assets\Sprites\" & Classification & "\" & ID & ".png" )
	
	Else
	
		Return 0
		
	End If
	
End Function

